/*
 * Decompiled with CFR 0.152.
 */
package com.smart.utils;

import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.ColorMatrix;
import android.graphics.ColorMatrixColorFilter;
import android.graphics.DrawFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PaintFlagsDrawFilter;
import android.util.Log;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.CRC32;
import java.util.zip.GZIPOutputStream;

public class PictureProcess {
    public static Bitmap scale(int width, Bitmap bitmap) {
        int height = (int)((float)width / (float)bitmap.getWidth() * (float)bitmap.getHeight());
        Bitmap scaleBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)bitmap.getConfig());
        Canvas canvas = new Canvas(scaleBitmap);
        float scaleX = (float)width / (float)bitmap.getWidth();
        float scaleY = (float)height / (float)bitmap.getHeight();
        Matrix matrix = new Matrix();
        matrix.setScale(scaleX, scaleY);
        Paint paint = new Paint(2);
        paint.setFlags(paint.getFlags() | 2);
        paint.setFilterBitmap(true);
        paint.setAntiAlias(true);
        canvas.drawColor(-1);
        canvas.setDrawFilter((DrawFilter)new PaintFlagsDrawFilter(0, 3));
        canvas.drawBitmap(bitmap, matrix, paint);
        return scaleBitmap;
    }

    public static Bitmap pixelsToBitmap(int[] pixels, int width, int height) {
        Bitmap bitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        bitmap.setPixels(pixels, 0, width, 0, 0, width, height);
        return bitmap;
    }

    public static int[] bitmapToPixels(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        return pixels;
    }

    public static Bitmap toGrayscale(Bitmap bitmap) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        int alpha = -16777216;
        for (int i = 0; i < height; ++i) {
            for (int j = 0; j < width; ++j) {
                int pixel = pixels[width * i + j];
                int r = (pixel & 0xFF0000) >> 16;
                int g = (pixel & 0xFF00) >> 8;
                int b = pixel & 0xFF;
                int grey = (int)(0.11 * (double)r + 0.59 * (double)g + 0.3 * (double)b);
                pixels[width * i + j] = grey = alpha | grey << 16 | grey << 8 | grey;
            }
        }
        Bitmap bitmap1 = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.RGB_565);
        bitmap1.setPixels(pixels, 0, bitmap.getWidth(), 0, 0, bitmap.getWidth(), bitmap.getHeight());
        return bitmap1;
    }

    public static Bitmap binaryzation(int threshold, Bitmap bitmap, boolean reverse) {
        bitmap = PictureProcess.toGrayscale(bitmap);
        int[] pixels = PictureProcess.bitmapToPixels(bitmap);
        PictureProcess.binaryzation(threshold, pixels, reverse);
        return PictureProcess.pixelsToBitmap(pixels, bitmap.getWidth(), bitmap.getHeight());
    }

    public static void binaryzation(int threshold, int[] pixels, boolean reverse) {
        for (int i = 0; i < pixels.length; ++i) {
            int a = (pixels[i] & 0xFF000000) >> 24;
            int r = (pixels[i] & 0xFF0000) >> 16;
            if (a < 0) {
                a = 127 - a + 127;
            }
            pixels[i] = threshold > r && a > 20 ? (reverse ? -1 : -16777216) : (reverse ? -16777216 : -1);
        }
    }

    public static int averageValueBinaryzation(int[] pixels) {
        int greyValues = 0;
        for (int i = 0; i < pixels.length; ++i) {
            int pixel = pixels[i];
            greyValues += (pixel & 0xFF0000) >> 16;
        }
        return greyValues / pixels.length;
    }

    public static Bitmap getFlyodBitmap(Bitmap bitmap, float fGamma) {
        int height = bitmap.getHeight();
        int width = bitmap.getWidth();
        int[] pixels = PictureProcess.bitmapToPixels(bitmap);
        float v2 = 1.0f;
        Bitmap scaleBitmap = PictureProcess.scale(16, bitmap);
        pixels = PictureProcess.bitmapToPixels(scaleBitmap);
        int level = PictureProcess.gammaLevel(pixels);
        v2 = level == 0 ? 5.7f : (level == 1 ? 4.7f : (level == 2 ? 4.6f : (level == 3 ? 4.5f : (level == 4 ? 4.3f : (level == 5 ? 4.2f : (level == 6 ? 4.0f : (level == 7 ? 3.9f : (level == 8 ? 3.8f : (level == 9 ? 3.7f : (level == 10 ? 3.6f : (level == 11 ? 3.5f : (level == 12 ? 3.0f : (level == 13 ? 1.2f : 0.5f)))))))))))));
        pixels = PictureProcess.bitmapToPixels(bitmap);
        PictureProcess.gamma(pixels, pixels, width, height, v2);
        Bitmap newBitmap = PictureProcess.pixelsToBitmap(pixels, width, height);
        return PictureProcess.filter(newBitmap, false);
    }

    public static int gammaLevel(int[] pixels) {
        int[] levels = new int[16];
        for (int i = 0; i < pixels.length; ++i) {
            int b = Color.blue((int)pixels[i]);
            if (b >= 0 && b < 16) {
                levels[0] = levels[0] + 1;
                continue;
            }
            if (b >= 16 && b < 48) {
                levels[1] = levels[1] + 1;
                continue;
            }
            if (b >= 48 && b < 64) {
                levels[2] = levels[2] + 1;
                continue;
            }
            if (b >= 64 && b < 80) {
                levels[3] = levels[3] + 1;
                continue;
            }
            if (b >= 80 && b < 96) {
                levels[4] = levels[4] + 1;
                continue;
            }
            if (b >= 96 && b < 112) {
                levels[5] = levels[5] + 1;
                continue;
            }
            if (b >= 112 && b < 128) {
                levels[6] = levels[6] + 1;
                continue;
            }
            if (b >= 128 && b < 144) {
                levels[7] = levels[7] + 1;
                continue;
            }
            if (b >= 144 && b < 160) {
                levels[8] = levels[8] + 1;
                continue;
            }
            if (b >= 160 && b < 176) {
                levels[9] = levels[9] + 1;
                continue;
            }
            if (b >= 176 && b < 192) {
                levels[10] = levels[10] + 1;
                continue;
            }
            if (b >= 192 && b < 208) {
                levels[11] = levels[11] + 1;
                continue;
            }
            if (b >= 208 && b < 224) {
                levels[12] = levels[12] + 1;
                continue;
            }
            if (b >= 224 && b < 240) {
                levels[13] = levels[13] + 1;
                continue;
            }
            levels[14] = levels[14] + 1;
        }
        int maxBr = 0;
        int level = 0;
        for (int i = 0; i < levels.length; ++i) {
            if (maxBr >= levels[i]) continue;
            maxBr = levels[i];
            level = i;
        }
        System.out.println("maxBr - " + maxBr + "\tlevel - " + level);
        return level;
    }

    public static void convertRGBToHSV(int[] rgbPixels, float[] lights) {
        float[] hsv = new float[3];
        float light = 0.0f;
        for (int i = 0; i < rgbPixels.length; ++i) {
            int pixel = rgbPixels[i];
            Color.RGBToHSV((int)Color.red((int)pixel), (int)Color.green((int)pixel), (int)Color.blue((int)pixel), (float[])hsv);
            light += hsv[2];
        }
        float v = light / (float)rgbPixels.length;
        Log.i((String)"ContentValues", (String)("v - " + v));
    }

    public static Bitmap filter(Bitmap bitmap, boolean reverse) {
        int imageWidth = bitmap.getWidth();
        int imageHeight = bitmap.getHeight();
        int[] oldImageBuf = PictureProcess.bitmapToPixels(bitmap);
        int[] newImageBuf = new int[imageWidth * imageHeight];
        int pixelNum = imageWidth * imageHeight;
        int[] eRgb = new int[3];
        for (int i = 0; i < pixelNum; ++i) {
            int row = i / imageWidth;
            int column = i % imageWidth;
            int ptr = oldImageBuf[i];
            int r = ptr & 0xFF;
            int g = ptr & 0xFF;
            int b = ptr & 0xFF;
            int nearColor = PictureProcess.getNearstColo(r, g, b);
            if (nearColor == 0) {
                newImageBuf[i] = reverse ? -1 : -16777216;
                eRgb[0] = r;
                eRgb[1] = g;
                eRgb[2] = b;
            } else {
                newImageBuf[i] = reverse ? -16777216 : -1;
                eRgb[0] = r - 255;
                eRgb[1] = g - 255;
                eRgb[2] = b - 255;
            }
            float rate1 = 0.4375f;
            float rate2 = 0.3125f;
            float rate3 = 0.1875f;
            float rate4 = 0.0625f;
            int num = 1;
            int rgb1 = PictureProcess.getPixel(oldImageBuf, imageWidth, imageHeight, row, column + num, rate1, eRgb);
            int rgb2 = PictureProcess.getPixel(oldImageBuf, imageWidth, imageHeight, row + num, column, rate2, eRgb);
            int rgb3 = PictureProcess.getPixel(oldImageBuf, imageWidth, imageHeight, row + num, column - num, rate3, eRgb);
            int rgb4 = PictureProcess.getPixel(oldImageBuf, imageWidth, imageHeight, row + num, column + num, rate4, eRgb);
            PictureProcess.setPixel(oldImageBuf, imageWidth, imageHeight, row, column + num, rgb1);
            PictureProcess.setPixel(oldImageBuf, imageWidth, imageHeight, row + num, column, rgb2);
            PictureProcess.setPixel(oldImageBuf, imageWidth, imageHeight, row + num, column - num, rgb3);
            PictureProcess.setPixel(oldImageBuf, imageWidth, imageHeight, row + num, column + num, rgb4);
        }
        return PictureProcess.pixelsToBitmap(newImageBuf, imageWidth, imageHeight);
    }

    private static void setPixel(int[] imageBuf, int width, int height, int row, int column, int value) {
        if (row < 0 || row >= height || column < 0 || column >= width) {
            return;
        }
        int index = row * width + column;
        imageBuf[index] = value;
    }

    private static int getPixel(int[] imageBuf, int width, int height, int row, int column, float rate, int[] eRgb) {
        if (row < 0 || row >= height || column < 0 || column >= width) {
            return -1;
        }
        int index = row * width + column;
        int ptr = imageBuf[index];
        int a = ptr & 0xFFFFFFFF;
        int r = ptr & 0xFF;
        int g = ptr & 0xFF;
        int b = ptr & 0xFF;
        int er = eRgb[0];
        int eg = eRgb[1];
        int eb = eRgb[2];
        r = PictureProcess.clamp(r + (int)(rate * (float)er));
        g = PictureProcess.clamp(g + (int)(rate * (float)eg));
        b = PictureProcess.clamp(b + (int)(rate * (float)eb));
        return a << 24 | r << 16 | g << 8 | b;
    }

    private static int clamp(int value) {
        return value > 255 ? 255 : (value < 0 ? 0 : value);
    }

    private static int getNearstColo(int r, int g, int b) {
        int distance255Squared;
        int distance0Squared = (int)(Math.pow(r, 2.0) + Math.pow(g, 2.0) + Math.pow(b, 2.0));
        if (distance0Squared < (distance255Squared = (int)(Math.pow(255 - r, 2.0) + Math.pow(255 - g, 2.0) + Math.pow(255 - b, 2.0)))) {
            return 0;
        }
        return 1;
    }

    public static Bitmap reverse(Bitmap bitmap) {
        int[] pixels = PictureProcess.bitmapToPixels(bitmap);
        for (int i = 0; i < pixels.length; ++i) {
            int a = pixels[i] >> 24 & 0xFF;
            pixels[i] = ~pixels[i] | a << 24;
        }
        return PictureProcess.pixelsToBitmap(pixels, bitmap.getWidth(), bitmap.getHeight());
    }

    public static Bitmap saturation(Bitmap bitmap, float saturation) {
        Bitmap bmp = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        ColorMatrix colorMatrix = new ColorMatrix();
        colorMatrix.setSaturation(saturation);
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(colorMatrix));
        Canvas canvas = new Canvas(bmp);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return bmp;
    }

    public static Bitmap brightness(Bitmap bitmap, int brightness) {
        Bitmap bmp = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        ColorMatrix cMatrix = new ColorMatrix();
        cMatrix.set(new float[]{1.0f, 0.0f, 0.0f, 0.0f, brightness, 0.0f, 1.0f, 0.0f, 0.0f, brightness, 0.0f, 0.0f, 1.0f, 0.0f, brightness, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(cMatrix));
        Canvas canvas = new Canvas(bmp);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return bmp;
    }

    public static Bitmap contrast(Bitmap bitmap, float v) {
        Bitmap bmp = Bitmap.createBitmap((int)bitmap.getWidth(), (int)bitmap.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        float contrast = (float)((double)(v + 64.0f) / 128.0);
        ColorMatrix cMatrix = new ColorMatrix();
        cMatrix.set(new float[]{contrast, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, contrast, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, contrast, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f});
        Paint paint = new Paint();
        paint.setColorFilter((ColorFilter)new ColorMatrixColorFilter(cMatrix));
        Canvas canvas = new Canvas(bmp);
        canvas.drawBitmap(bitmap, 0.0f, 0.0f, paint);
        return bmp;
    }

    public static int[] doBlur(int[] pix, int width, int height, int radius) {
        int stackstart;
        int x;
        int stackpointer;
        int rbs;
        int[] sir;
        int p;
        int rinsum;
        int ginsum;
        int binsum;
        int routsum;
        int goutsum;
        int boutsum;
        int rsum;
        int gsum;
        int bsum;
        int y;
        int i;
        int wm = width - 1;
        int hm = height - 1;
        int wh = width * height;
        int div = radius + radius + 1;
        int[] r = new int[wh];
        int[] g = new int[wh];
        int[] b = new int[wh];
        int[] vmin = new int[Math.max(width, height)];
        int divsum = div + 1 >> 1;
        divsum *= divsum;
        int[] dv = new int[256 * divsum];
        for (i = 0; i < 256 * divsum; ++i) {
            dv[i] = i / divsum;
        }
        int yi = 0;
        int yw = 0;
        int[][] stack = new int[div][3];
        int r1 = radius + 1;
        for (y = 0; y < height; ++y) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            for (i = -radius; i <= radius; ++i) {
                p = pix[yi + Math.min(wm, Math.max(i, 0))];
                sir = stack[i + radius];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rbs = r1 - Math.abs(i);
                rsum += sir[0] * rbs;
                gsum += sir[1] * rbs;
                bsum += sir[2] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                    continue;
                }
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
            }
            stackpointer = radius;
            for (x = 0; x < width; ++x) {
                r[yi] = dv[rsum];
                g[yi] = dv[gsum];
                b[yi] = dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (y == 0) {
                    vmin[x] = Math.min(x + radius + 1, wm);
                }
                p = pix[yw + vmin[x]];
                sir[0] = (p & 0xFF0000) >> 16;
                sir[1] = (p & 0xFF00) >> 8;
                sir[2] = p & 0xFF;
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer % div];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                ++yi;
            }
            yw += width;
        }
        for (x = 0; x < width; ++x) {
            bsum = 0;
            gsum = 0;
            rsum = 0;
            boutsum = 0;
            goutsum = 0;
            routsum = 0;
            binsum = 0;
            ginsum = 0;
            rinsum = 0;
            int yp = -radius * width;
            for (i = -radius; i <= radius; ++i) {
                yi = Math.max(0, yp) + x;
                sir = stack[i + radius];
                sir[0] = r[yi];
                sir[1] = g[yi];
                sir[2] = b[yi];
                rbs = r1 - Math.abs(i);
                rsum += r[yi] * rbs;
                gsum += g[yi] * rbs;
                bsum += b[yi] * rbs;
                if (i > 0) {
                    rinsum += sir[0];
                    ginsum += sir[1];
                    binsum += sir[2];
                } else {
                    routsum += sir[0];
                    goutsum += sir[1];
                    boutsum += sir[2];
                }
                if (i >= hm) continue;
                yp += width;
            }
            yi = x;
            stackpointer = radius;
            for (y = 0; y < height; ++y) {
                pix[yi] = 0xFF000000 & pix[yi] | dv[rsum] << 16 | dv[gsum] << 8 | dv[bsum];
                rsum -= routsum;
                gsum -= goutsum;
                bsum -= boutsum;
                stackstart = stackpointer - radius + div;
                sir = stack[stackstart % div];
                routsum -= sir[0];
                goutsum -= sir[1];
                boutsum -= sir[2];
                if (x == 0) {
                    vmin[y] = Math.min(y + r1, hm) * width;
                }
                p = x + vmin[y];
                sir[0] = r[p];
                sir[1] = g[p];
                sir[2] = b[p];
                rsum += (rinsum += sir[0]);
                gsum += (ginsum += sir[1]);
                bsum += (binsum += sir[2]);
                stackpointer = (stackpointer + 1) % div;
                sir = stack[stackpointer];
                routsum += sir[0];
                goutsum += sir[1];
                boutsum += sir[2];
                rinsum -= sir[0];
                ginsum -= sir[1];
                binsum -= sir[2];
                yi += width;
            }
        }
        return pix;
    }

    public static native void gamma(int[] var0, int[] var1, int var2, int var3, float var4);

    public static native void sierraDithering(int[] var0, int[] var1, int var2, int var3);

    public static native void saturation(int[] var0, int[] var1, int var2, int var3, int var4);

    public static native void gaussianBlur(int[] var0, int[] var1, int var2, int var3, int var4);

    public static native void divide(int[] var0, int[] var1, int[] var2, int var3, int var4);

    public static native void gray(int[] var0, int[] var1, int var2, int var3);

    public static native void filter(int[] var0, int[] var1, int var2, int var3, boolean var4);

    public static byte[] drawPageBitmap(Bitmap bitmap, int printerDotWidth) {
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int myBitmapWidth = width;
        int myBitmapHeight = height;
        Bitmap myBitmap = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
        Canvas myCanvas = new Canvas(myBitmap);
        Paint myPaint = new Paint();
        myPaint.setColor(-16777216);
        myPaint.setTextSize(10.0f);
        myPaint.setTextAlign(Paint.Align.LEFT);
        myPaint.setStrokeWidth(10.0f);
        myCanvas.drawColor(-1);
        myCanvas.drawBitmap(bitmap, 0.0f, 0.0f, myPaint);
        if (myBitmapWidth > printerDotWidth) {
            myBitmapWidth = printerDotWidth;
        }
        int len = (myBitmapWidth + 7) / 8;
        byte[] bitmapdata = new byte[(len + 4) * myBitmapHeight];
        int ndata = 0;
        int h = 0;
        int w = 0;
        int[] pixels = new int[myBitmapWidth * myBitmapHeight];
        myBitmap.getPixels(pixels, 0, myBitmapWidth, 0, 0, myBitmapWidth, myBitmapHeight);
        myBitmap.recycle();
        for (h = 0; h < myBitmapHeight; ++h) {
            int size;
            bitmapdata[ndata + 0] = 31;
            bitmapdata[ndata + 1] = 16;
            bitmapdata[ndata + 2] = (byte)(len % 256);
            bitmapdata[ndata + 3] = (byte)(len / 256);
            for (w = 0; w < len; ++w) {
                bitmapdata[ndata + 4 + w] = 0;
            }
            for (w = 0; w < myBitmapWidth; ++w) {
                int color2 = pixels[h * myBitmapWidth + w];
                int r = color2 >> 16 & 0xFF;
                int g = color2 >> 8 & 0xFF;
                int b = color2 >> 0 & 0xFF;
                int gray = (r + g + b) / 3;
                if (gray >= 153) continue;
                int n = ndata + 4 + w / 8;
                bitmapdata[n] = (byte)(bitmapdata[n] | (byte)(128 >> w % 8));
            }
            for (size = len - 1; size >= 0 && bitmapdata[ndata + 4 + size] == 0; --size) {
            }
            ++size;
            size = len;
            bitmapdata[ndata + 2] = (byte)(size % 256);
            bitmapdata[ndata + 3] = (byte)(size / 256);
            ndata += 4 + size;
        }
        bitmapdata = PictureProcess.codec(bitmapdata);
        return bitmapdata;
    }

    public static byte[] codec(byte[] data) {
        byte[] gzipData = null;
        ByteArrayOutputStream gzipStram = new ByteArrayOutputStream();
        try {
            GZIPOutputStream zos = new GZIPOutputStream(new BufferedOutputStream(gzipStram));
            zos.write(data);
            zos.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        gzipData = gzipStram.toByteArray();
        long length = gzipData.length;
        CRC32 crc32 = new CRC32();
        crc32.update(gzipData, 8, (int)(length - 8L - 4L));
        long crc = crc32.getValue();
        gzipData[4] = (byte)(length >> 0 & 0xFFL);
        gzipData[5] = (byte)(length >> 8 & 0xFFL);
        gzipData[6] = (byte)(length >> 16 & 0xFFL);
        gzipData[7] = (byte)(length >> 24 & 0xFFL);
        gzipData[gzipData.length - 4] = (byte)(crc >> 0 & 0xFFL);
        gzipData[gzipData.length - 3] = (byte)(crc >> 8 & 0xFFL);
        gzipData[gzipData.length - 2] = (byte)(crc >> 16 & 0xFFL);
        gzipData[gzipData.length - 1] = (byte)(crc >> 24 & 0xFFL);
        return gzipData;
    }

    static {
        System.loadLibrary("picture-lib");
    }
}

